//
// Nom du script : server.js
// Auteur : Christian VIGOUROUX - ENI Editions
// Date de création : 26/12/2023
// Date de dernière modification : 26/12/2023
// Objet : Script JavaScript server.js assurant l'interface
//         entre l'application Vue3.js
//         et le SGBD MySQL
//

// Importation des librairies
const express = require('express');
const mysql = require('mysql2');
const cors = require("cors");

// Instanciation du serveur Express en écoute sur le port 3000
const app = express();
const port = 3000;

// Configuration de la connexion à la base de données MySQL
const db = mysql.createConnection({
  host: 'localhost',
  user: 'root',
  password: '',
  database: 'vue3js'
});

// Connexion à la Base De Données
db.connect((err) => {

  // Test de connexion à la Base De Données
  if (err) {
    
    // Affiche de contrôle dans la console (Echec)
    console.error(
      'Erreur de connexion à la base de données MySQL :', err
    );
  
  } else {
    
    // Affiche de contrôle dans la console (Succès)
    console.log(
      'Connecté à la base de données MySQL'
    );
  
  }

});

// Middleware permettant l'analyse du corps des requêtes au format JSON
app.use(express.json());

// Utilisation de CORS pour autoriser les requêtes 
// depuis votre application Vue.js
app.use(cors());

// Endpoint (route) pour récupérer les informations
// d'une voiture par son Id
app.get('/voiture', (req, res) => {

  // Récupération de l'Id depuis la requête
  const { id } = req.query;
  
  // Test si l'Id a été passée par l'application cliente
  if (!id) {
    
    // Affichage de contrôle (pas d'Id fourni)
    res.status(400).json(
      { error: 'L\'Id de la voiture est requise' }
    );
    
    // Sortie forcée
    return;

  }

  // Requête SQL de sélection d'une voiture en fonction de son Id
  const sql = `SELECT id, marque, modele FROM voitures WHERE id = ${db.escape(id)}`;

  // Exécution de la requête SQL de sélection des données
  db.query(sql, (err, result) => {
    
    // Cas d'échec
    if (err) {
      
      // Affichage de contrôle (échec)
      res.status(500).json(
        { error: 'Erreur lors de la récupération des informations de la voiture' }
      );
    
      // Cas de succès
    } else {
      
      // Envoi des données des voitures au format JSON
      // à l'application cliente
      res.status(200).json(result);

    }

  });

});

// Écoute le serveur sur le port 3000
app.listen(port, () => {

  // Affichage de contrôle dans la console
  console.log(
    `Serveur Express en cours d'exécution sur le port ${port}`
  );

});